/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.EqualsCheck;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Language;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;

public class ParameterItem
implements EqualsCheck,
DisplayElement,
Cloneable,
Serializable,
Storable {
    static final long serialVersionUID = 7994444430469891720L;
    protected BlockParameter fParameter = null;
    protected int fMaxLength;
    protected boolean fPublicAccessible;
    protected boolean fPublicToUDF;
    protected boolean fPublicToVM;
    protected boolean fEditableForVM;
    protected int fLengthInVM;
    protected int fParameterNumber;
    protected String fName;
    protected transient Method fGetMethod;
    protected String fIdentifier;
    protected transient Method fSetMethod;
    protected boolean fEditable;
    protected Class fParameterClass;
    protected int fParameterValueType;
    private boolean fParameterSourceUsable;
    private String fGetterSetterName;
    private byte fValueOrReferenceID;
    private boolean fLeadingZeros;

    public ParameterItem() {
    }

    public ParameterItem(Class blockParameterClass, String identifier, int parameterNumber, String nameKey, String getterSetterName, int maxLength, boolean publicAccessible, boolean editable, int parameterValueType, boolean parameterSource, byte valueOrReferenceID, boolean leadingZero) {
        this.fName = Language.getString(nameKey, nameKey);
        this.fIdentifier = identifier;
        this.fParameterNumber = parameterNumber;
        this.fParameterClass = blockParameterClass;
        this.fPublicAccessible = publicAccessible;
        this.fEditable = editable;
        this.fMaxLength = maxLength;
        this.fParameterValueType = parameterValueType;
        this.fParameterSourceUsable = parameterSource;
        this.fGetterSetterName = getterSetterName;
        this.fValueOrReferenceID = valueOrReferenceID;
        this.fLeadingZeros = leadingZero;
    }

    public ParameterItem(Class blockParameterClass, String identifier, int parameterNumber, String nameKey, String getterSetterName, int maxLength, boolean publicAccessible, boolean editable, int parameterValueType, boolean parameterSource, byte valueOrReferenceID, boolean leadingZero, boolean udfReferAccessible, boolean vmAccessible, boolean editableForVM, int vmLength) {
        this(blockParameterClass, identifier, parameterNumber, nameKey, getterSetterName, maxLength, publicAccessible, editable, parameterValueType, parameterSource, valueOrReferenceID, leadingZero);
        this.fPublicToUDF = udfReferAccessible;
        this.fPublicToVM = vmAccessible;
        this.fEditableForVM = editableForVM;
        this.fLengthInVM = vmLength;
    }

    public String getLocalisedName() {
        return this.fName;
    }

    protected Method determineGetMethod(Class blockParameterClass, String getterSetterName) throws NoSuchMethodException {
        Method getter = null;
        try {
            getter = blockParameterClass.getMethod("get" + getterSetterName, new Class[0]);
        }
        catch (NoSuchMethodException exception) {
            getter = blockParameterClass.getMethod("is" + getterSetterName, new Class[0]);
        }
        return getter;
    }

    protected Method determineSetMethod(Class blockParameterClass, String getterSetterName) throws NoSuchMethodException {
        Method setter = blockParameterClass.getMethod("set" + getterSetterName, this.getGetMethod().getReturnType());
        return setter;
    }

    public String toString() {
        return this.getLocalisedName();
    }

    public Object getValue() {
        Object value = null;
        try {
            value = this.getGetMethod().invoke((Object)this.fParameter, new Object[0]);
        }
        catch (Exception e) {
            System.err.println("Wahrscheinlich wurde im ParameterItem kein ParameterObjekt gesetzt\n Es ist paramItemList.instance() zu verwenden!");
            e.printStackTrace();
        }
        return value;
    }

    public void setValue(Object value) {
        try {
            this.getSetMethod().invoke((Object)this.fParameter, value);
        }
        catch (Exception e) {
            System.out.println("ParameterItem.setValue():");
            e.printStackTrace();
        }
    }

    public int getHeight() {
        return 1;
    }

    public int getWidth() {
        int length = this.fMaxLength;
        try {
            Hardware hardware;
            WiringDiagram wiringDiagram = this.getParameter().getBlock().getWiringDiagram();
            if (wiringDiagram != null && !(hardware = wiringDiagram.getHardware()).supports("mixedMessageTextAndParameter")) {
                length = hardware.getIntProperty("displayWidth");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return length;
    }

    public int getMinWidth() {
        return this.fMaxLength;
    }

    public ParameterItem getInstanceForParameter(BlockParameter parameter) {
        ParameterItem clone = null;
        try {
            clone = (ParameterItem)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        clone.setParameter(parameter);
        return clone;
    }

    public BlockParameter getParameter() {
        return this.fParameter;
    }

    public void setParameter(BlockParameter parameter) {
        this.fParameter = parameter;
    }

    public boolean isEditable() {
        return this.fEditable;
    }

    public Class getParameterClass() {
        return this.fParameterClass;
    }

    public String getIdentifier() {
        return this.fIdentifier;
    }

    public int getParameterNumber() {
        return this.fParameterNumber;
    }

    public boolean isPublicAccessible() {
        return this.fPublicAccessible;
    }

    public boolean isPublicToVM() {
        return this.fPublicToVM;
    }

    public boolean isActualValue() {
        return this.fParameterValueType == 1;
    }

    public boolean isPublicToUDF() {
        return this.fPublicToUDF;
    }

    public boolean isParameterSourceUsable() {
        return this.fParameterSourceUsable;
    }

    public Method getGetMethod() throws NoSuchMethodException {
        if (this.fGetMethod == null) {
            this.fGetMethod = this.determineGetMethod(this.fParameterClass, this.fGetterSetterName);
        }
        return this.fGetMethod;
    }

    public Method getSetMethod() throws NoSuchMethodException {
        if (this.fSetMethod == null) {
            this.fSetMethod = this.determineSetMethod(this.fParameterClass, this.fGetterSetterName);
        }
        return this.fSetMethod;
    }

    public int getParameterValueType() {
        return this.fParameterValueType;
    }

    public void write(StorableOutput dw) {
        dw.writeBoolean(this.fEditable);
        dw.writeString(this.fGetterSetterName);
        dw.writeString(this.fIdentifier);
        dw.writeInt(this.fMaxLength);
        dw.writeString(this.fName);
        dw.writeStorable(this.fParameter);
        dw.writeClass(this.fParameterClass);
        dw.writeInt(this.fParameterNumber);
        dw.writeBoolean(this.fParameterSourceUsable);
        dw.writeInt(this.fParameterValueType);
        dw.writeBoolean(this.fPublicAccessible);
        dw.writeBoolean(this.fLeadingZeros);
        dw.writeBoolean(this.fEditableForVM);
        dw.writeBoolean(this.fPublicToVM);
        dw.writeBoolean(this.fPublicToUDF);
    }

    public void read(StorableInput dr) throws IOException {
        this.fEditable = dr.readBoolean();
        this.fGetterSetterName = dr.readString();
        this.fIdentifier = dr.readString();
        this.fMaxLength = dr.readInt();
        this.fName = dr.readString();
        this.fParameter = (BlockParameter)dr.readStorable();
        this.fParameterClass = dr.readClass();
        this.fParameterNumber = dr.readInt();
        this.fParameterSourceUsable = dr.readBoolean();
        this.fParameterValueType = dr.readInt();
        this.fPublicAccessible = dr.readBoolean();
        this.fLeadingZeros = dr.readBoolean();
        this.fEditableForVM = dr.readBoolean();
        this.fPublicToVM = dr.readBoolean();
        this.fPublicToUDF = dr.readBoolean();
    }

    public byte getValueOrReferenceID() {
        return this.fValueOrReferenceID;
    }

    public boolean isEqual(Object element) {
        if (!(element instanceof ParameterItem)) {
            return false;
        }
        return ((ParameterItem)element).getIdentifier().equals(this.getIdentifier());
    }

    public boolean isLeadingZeros() {
        return this.fLeadingZeros;
    }

    public boolean equals(Object value) {
        if (value == null) {
            return false;
        }
        if (value.getClass() != ParameterItem.class) {
            return false;
        }
        ParameterItem item = (ParameterItem)value;
        return item.getParameter() == this.getParameter() && item.getIdentifier().equals(this.getIdentifier());
    }

    public boolean isContentsEquals(Object value) {
        if (!(value instanceof ParameterItem)) {
            return false;
        }
        ParameterItem item = (ParameterItem)value;
        return this.getParameterClass() == item.getParameterClass() && this.getParameter().getBlock().getNumberString().equals(item.getParameter().getBlock().getNumberString()) && this.getIdentifier().equals(item.getIdentifier());
    }

    public String getContentsString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.getParameter().getBlock().getNumberString());
        ret.append("-");
        ret.append(this.getIdentifier());
        return ret.toString();
    }

    public String getGetterSetterName() {
        return this.fGetterSetterName;
    }

    public int getLengthInVM() {
        return this.fLengthInVM;
    }

    public boolean isEditableViaVM() {
        return this.fEditableForVM;
    }
}

